function pitch_track = tvgmm(gct_est,win,K,framenos)
% Finds the multi-pitch track using tvgmm (2 - speaker) 
% example usage:
% pitch_track = tvgmm(gct_est,N,win,K,framenos)
%
% INPUTS:
% gct_est -  Matrix containing pitch estimates in each frame obtained using
%            GCT of patches across frquency range of spectrogram (frame
%            duration should be 25ms)
% K -        Degree of polynomial which fits tvgmm parameter (default-4)
% 
%
% win -      number of frames over which time-varying mean polynomial is
%            fitted (default - 10)
% 
% framenos (optional) - Start and end frame numbers in which both speakers are voiced. (min-5 max-10 consecutive frames)                      
%                    
%                        
%                       
%
% OUTPUT:
% pitch_track - pitch values in each frame with each row correspnding to
% 'n'th speaker (n = 1,2)
  X = gct_est;
if nargin<4
         N = 2;
         win = 10;
         K = 4;
         tmp = 1:10:size(X,1);
         framenos = [tmp,tmp+win];
end
            for m = 1:size(framenos,1)
                winnew = framenos(m,2) - framenos(m,1) + 1;
                if(winnew>5)
                    win = winnew;
                    t=25E-3:25E-3:(25E-3)*win;
                    T=[ones(1,length(t));t;t.^2];
                    X1 = X(framenos(m,1):framenos(m,2),:);
                    Ynew={};

                        for i=1:win
                            x=X1(i,:);
                            x=x(find(x~=0));
                            Ynew(i)={x};
                        end


                    p=[0.5;0.5];
                    sig=25;

                    Centres=zeros(size(Ynew,2),2);

                    for i=1:size(Ynew,2)
                        y=cell2mat(Ynew(i));


                        try
                            [idx c]=kmeans(y',2);
                        catch err
                            c=[0;0];
                        end

                        if(length(idx)>1)
                            if(i>1)
                                diff(1)=abs(Centres(i-1,1)-c(1));
                                diff(2)=abs(Centres(i-1,2)-c(1));
                                diff(3)=abs(Centres(i-1,1)-c(2));
                                diff(4)=abs(Centres(i-1,2)-c(2));
                                [vals ind]=sort(diff);
                                if(ind(1) == 1)
                                        Centres(i,:)=[c(1),c(2)];

                                elseif(ind(1) == 2)
                                        Centres(i,:)=[c(2),c(1)];

                                elseif(ind(1) == 3)
                                        Centres(i,:)=[c(2),c(1)];

                                else
                                        Centres(i,:)=[c(1),c(2)];

                                end
                            else
                                Centres(i,:)=[c(1),c(2)];
                            end
                        else
                            Centres(i,:)=[c(1),0];
                        end
                    end
                    pitch_median(m)={Centres};

                    a_init1=[Centres(1,1),0.1,0.1]; 
                    a_init2=[Centres(1,2),0.1,0.1]; 
                    mu_poly1_init=a_init1*T;
                    mu_poly2_init=a_init2*T;
                    mu_init=[mu_poly1_init;mu_poly2_init];
                    a_init=[a_init1;a_init2];

                    gamma_ijt=gammacalc(Ynew,mu_init,sig,p);

                    iter=200;
                    a_k=a_init;
                    eta=0.01;

                    for k=1:iter
                        for j=1:2
                            sum_allt=zeros(win,3);
                            for t=1:win
                                y=cell2mat(Ynew(t));
                                temp=a_k(j,:)*T(:,t);
                                sum_alli=zeros(3,1);
                                gamma_ij=cell2mat(gamma_ijt(t));

                                for i=1:size(y,2)
                                    sum_alli(1)=sum_alli(1)+gamma_ij(i,j)*(y(i)-temp);
                                    sum_alli(2)=sum_alli(2)+(t*25E-2)*gamma_ij(i,j)*(y(i)-temp);
                                    sum_alli(3)=sum_alli(3)+((t*25E-2)^2)*gamma_ij(i,j)*(y(i)-temp);
                                end
                                sum_allt(t,:)=sum_alli;
                            end
                            sum_all=sum(sum_allt,1);
                            a_kp1(j,1)=a_k(j,1)+(eta*sum_all(1))/sig;
                            a_kp1(j,2)=a_k(j,2)+(eta*sum_all(2))/sig; 
                            a_kp1(j,3)=a_k(j,3)+(eta*sum_all(3))/sig; 
                        end
                        mu_k=[a_kp1(1,:)*T;a_kp1(2,:)*T];

                        gamma_ijt=gammacalc(Ynew,mu_k,sig,p);

                        opt_value=objvalue(gamma_ijt,Ynew,a_kp1,sig);
                        a_k=a_kp1;
                        iter-k;
                    end
                    pitch_track(m)={mu_k};    
                end
            end
