function optimize_hyperparameter(bag_file,acoustic_ctrl_file,ema_ctrl_file,estimate_ema_ctrl_file,pftr_ctrl_file,label_dir,hyperparameter_file,period)
load('LUT');
no_of_bags=length(lut);

fid=fopen(acoustic_ctrl_file);
cnt=1;
while ~feof(fid)
    tline = fgets(fid);
    temp=regexp(tline,'[\r\f\n]','split');
    acoustic_files{cnt}=temp{1};
    cnt=cnt+1;
end

fclose(fid);

fid=fopen(estimate_ema_ctrl_file);
cnt=1;
while ~feof(fid)
    tline = fgets(fid);
    temp=regexp(tline,'[\r\f\n]','split');
    estimate_ema_files{cnt}=temp{1};
    cnt=cnt+1;
end

fclose(fid);

fid=fopen(pftr_ctrl_file);
cnt=1;

while ~feof(fid)
    tline = fgets(fid);
    temp=regexp(tline,'[\r\f\n]','split');
    pftr_files{cnt}=temp{1};
    cnt=cnt+1;
end

fclose(fid);


load(bag_file);

epsilon=10^(-100);

%Estimating articulators
for count=1:length(acoustic_files)
    
    
    acoustic_file = acoustic_files{count};
    ind=find(acoustic_file=='/');
    filename = acoustic_file(ind(end)+1:end-4);
    
    disp(['Estimating articulators for development for ' acoustic_files{count}]);
    if isempty(dir([label_dir filename '.txt']))
        %To get the state and phonemes using HTK viterbi alignment
        system(['HVite -l ' label_dir ' -C config_2 -H models/hmmdefs -f -m -t 250.0 -w wdnet -o SW -y txt dico phones ' acoustic_files{count}]);
    end
    data=readlabelfile([label_dir filename '.txt'],period);
    
    
    load(pftr_files{count});
    
    x_dim=size(pftr,2);
    y_dim=size(bag{1},2)-x_dim;
    
    yest=zeros(size(pftr,1),y_dim);
    for cntframes=1:size(pftr,1)
        for cntbag=1:no_of_bags
            if(strcmp(char(data{cntframes}),lut{cntbag,1}))
                bagno=cntbag;
                if isempty(bag{bagno})
                    bagno=bagno+1;
                end
            end
        end;
        normterm=1./(epsilon+abs((repmat(max(pftr(cntframes,:)),[size(bag{bagno},1),1]))-(max((bag{bagno}(:,1:x_dim))')')));
        normterm=normterm/sum(normterm);
        yest(cntframes,:)=sum(bag{bagno}(:,(x_dim+1):(x_dim+y_dim)).*repmat(normterm,[1,y_dim]));
    end;
    save(estimate_ema_files{count},'yest');
end

freq_value=inv_perf_hyperparameter(ema_ctrl_file,estimate_ema_ctrl_file,period);
save(hyperparameter_file,'freq_value');
end

