function create_bags(acoustic_ctrl_file,ema_ctrl_file,pftr_ctrl_file,label_dir,bag_file,period)
load('LUT');
no_of_bags=length(lut);
%Loading the control files
fid=fopen(acoustic_ctrl_file);
cnt=1;

while ~feof(fid)
    tline = fgets(fid);
    temp=regexp(tline,'[\r\f\n]','split');
    acoustic_files{cnt}=temp{1};
    cnt=cnt+1;
end

fclose(fid);

fid=fopen(ema_ctrl_file);
cnt=1;
while ~feof(fid)
    tline = fgets(fid);
    temp=regexp(tline,'[\r\f\n]','split');
    ema_files{cnt}=temp{1};
    cnt=cnt+1;
end

fclose(fid);

fid=fopen(pftr_ctrl_file);
cnt=1;

while ~feof(fid)
    tline = fgets(fid);
    temp=regexp(tline,'[\r\f\n]','split');
    pftr_files{cnt}=temp{1};
    cnt=cnt+1;
end

fclose(fid);

%Storing into bags
bag=cell(1,no_of_bags);
for i=1:length(acoustic_files)
    
    acoustic_file = acoustic_files{i};
    ind=find(acoustic_file=='/');
    filename = acoustic_file(ind(end)+1:end-4);
    
    disp(['Finding bag for ' acoustic_files{i}]);
    if isempty(dir([label_dir filename '.txt']))
        %To get the state and phonemes using HTK viterbi alignment
        system(['HVite -l ' label_dir ' -C config_2 -H hmmdefs -J xforms_train mllr2 -k -f -m -t 250.0 -w wdnet -o SW -J classes -y txt dico phones ' acoustic_files{i}]);
    end
    data1=readlabelfile([label_dir filename '.txt'],period);
    
    load(pftr_files{i});
    temp=load(ema_files{i});field=fieldnames(temp);
    %    ema=getfield(temp,field{1}); %ema
    %    arti=ema(1:5:end,:);
    arti=getfield(temp,field{1});
    
    %Equalising the size of data
    if(size(arti,1)<=size(pftr,1))
        datapftr=pftr(1:size(arti,1),:);
        dataarti=arti;
        data=data1(1:size(art,1),:);
    else
        datapftr=pftr;
        dataarti=arti(1:size(pftr,1),:);
        data=data1;
    end;
    
    for cnt=1:size(datapftr,1)
        
        for cntbag=1:no_of_bags
            if(strcmp(char(data{cnt}),lut{cntbag,1}))
                bagno=cntbag;
            end;
        end;
        
        if(size(bag{bagno}))
            inbag=bag{bagno};
            bag{bagno}=[inbag; [datapftr(cnt,:) dataarti(cnt,:)]];
        else
            bag{bagno}=[datapftr(cnt,:) dataarti(cnt,:)];
        end;
        
    end;
end;

save(bag_file,'bag');
end
