function convert_mfc_probftr(acoustic_ctrl_file,pftr_ctrl_file,GAS_GMM_DIR)

mixall=[];
all_gmms=dir([GAS_GMM_DIR '*.mat']);
for i=1:length(all_gmms)
    load([GAS_GMM_DIR all_gmms(i).name]);
    mixall{i}=mix;
end


fid=fopen(acoustic_ctrl_file);
cnt=1;

while ~feof(fid)
    tline = fgets(fid);
    temp=regexp(tline,'[\r\f\n]','split');
    acoustic_files{cnt}=temp{1};
    cnt=cnt+1;
end

fclose(fid);

fid=fopen(pftr_ctrl_file);
cnt=1;

while ~feof(fid)
    tline = fgets(fid);
    temp=regexp(tline,'[\r\f\n]','split');
    pftr_files{cnt}=temp{1};
    cnt=cnt+1;
end

fclose(fid);

for i=1:length(acoustic_files)
    if(~exist(pftr_files{i},'file'))
    disp(['Calculating pftr for ' acoustic_files{i}]);
    mfcc=readhtk(acoustic_files{i});
    
    pftr=[];
    for j=1:length(mixall)
        pftr=[pftr gmmprob(mixall{j},mfcc)];
    end
    s_pftr=sum(pftr,2);
    pftr=pftr./repmat(s_pftr,1,size(pftr,2));
 
    save(pftr_files{i},'pftr');
    end;
end
