function freq_value=inv_perf_hyperparameter(ema_ctrl_file,estimate_ema_ctrl_file,period)

fid=fopen(estimate_ema_ctrl_file);
cnt=1;
while ~feof(fid)
    tline = fgets(fid);
    temp=regexp(tline,'[\r\f\n]','split');
    estimate_ema_files{cnt}=temp{1};
    cnt=cnt+1;
end
fclose(fid);

fid=fopen(ema_ctrl_file);
cnt=1;
while ~feof(fid)
    tline = fgets(fid);
    temp=regexp(tline,'[\r\f\n]','split');
    ema_files{cnt}=temp{1};
    cnt=cnt+1;
end
fclose(fid);

%Concatinating all the estimates and ema files to avoid loading repeatedly
datayest=cell(length(ema_files),1);
dataarti=cell(length(ema_files),1);

for count=1:length(ema_files)
    load(estimate_ema_files{count});
    
    temp=load(ema_files{count});field=fieldnames(temp);
    %ema=getfield(temp,field{1}); %ema
    %arti=ema(1:5:end,:);
    arti=getfield(temp,field{1});
    
    if(size(arti,1)<=size(yest,1))
        datayest{count}=yest(1:size(arti,1),:);
        dataarti{count}=arti;
    else
        datayest{count}=yest;
        dataarti{count}=arti(1:size(yest,1),:);
    end;
end;


freq_value=zeros(1,size(arti,2)); %Stores the optimised frequencies

%Computing for each articulatory feature seperately
for countfeature=1:size(arti,2)
    disp(['Optimising parameters for feature' int2str(countfeature)]);
    rmse=inf;
    
    for value=3:1:(2500*period)
        
        [B,A]=cheby2(3,40,value/(5000*period));
        
        rms_utterance=zeros(1,length(ema_files));
        for countrms=1:length(ema_files)
            esty=datayest{countrms}(:,countfeature);
            datay=filtfilt(B,A,esty);
            dataema=dataarti{countrms}(:,countfeature);
            rms_utterance(countrms)=sqrt(sum((datay-dataema).^2)/size(dataarti{countrms},1));
        end;
        
        
        avg_rms=(sum(rms_utterance))/length(ema_files);
        
        if(rmse>avg_rms)
            rmse=avg_rms;
            freq_value(1,countfeature)=value;
        end;
        
    end;
end;
end