%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%% please delete/change the following before you run
%%%%%%%%%%% if new GAS: delete pftr folder
%%%%%%%%%%% if new GAS + new arti_ftr: delete bags and Hyperparameters folders
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear; clc;
addpath netlab;

period=0.01;

train_acoustic_ctrl_file='control_files/train_mfc.txt';
dev_acoustic_ctrl_file='control_files/dev_mfc.txt';
test_acoustic_ctrl_file='control_files/test_mfc.txt';

train_pftr_ctrl_file='control_files/train_pftr.txt';
dev_pftr_ctrl_file='control_files/dev_pftr.txt';
test_pftr_ctrl_file='control_files/test_pftr.txt';
train_ema_ctrl_file='control_files/train_arti.txt';
dev_ema_ctrl_file='control_files/dev_arti.txt';


train_label_dir='label_files/train/';
dev_label_dir='label_files/dev/';
test_label_dir='label_files/test/';

system('mkdir -p dev_est_files/; rm -rf dev_est_files/*');
create_dev_estimated;
dev_estimate_ema_ctrl_file='control_files/dev_estimated_arti.txt';
test_estimate_ema_ctrl_file='control_files/test_arti.txt';

GMM_dir='GAS_scheme2/';
bag_file='Bags.mat';
hyperparameter_file='HypParam.mat';

%%%%% for treating all frames jointly given the entire file
disp('Calculating probabilty features for train data...');
convert_mfc_probftr(train_acoustic_ctrl_file,train_pftr_ctrl_file,GMM_dir);
disp('Calculating probabilty features for development data...');
convert_mfc_probftr(dev_acoustic_ctrl_file,dev_pftr_ctrl_file,GMM_dir);
disp('Calculating probabilty features for test data...');
convert_mfc_probftr(test_acoustic_ctrl_file,test_pftr_ctrl_file,GMM_dir);

disp('Creating bags....');
create_bags(train_acoustic_ctrl_file,train_ema_ctrl_file,train_pftr_ctrl_file,train_label_dir,bag_file,period);
disp('Done creating bags')

disp('Optimising hyper parameters...');
optimize_hyperparameter(bag_file,dev_acoustic_ctrl_file,dev_ema_ctrl_file,dev_estimate_ema_ctrl_file,dev_pftr_ctrl_file,dev_label_dir,hyperparameter_file,period);
%%%%calls inv_perf_hyperparameter(dev_ema_ctrl_file,dev_estimate_ema_ctrl_file,period)
disp('Optimise done')

disp('Estimating articulators..');
estimate_test_ema(test_acoustic_ctrl_file,test_estimate_ema_ctrl_file,test_pftr_ctrl_file,test_label_dir,hyperparameter_file,bag_file,period);
disp('Estimation done');