function create_phn_gmms(hmmdeffile,GMM_dir)
format long
fid=fopen(hmmdeffile);

while ~feof(fid)
    tline = fgets(fid);
    temp=regexp(tline,'[\r\f\n]','split');
    linein=temp{1};
    %For each Phoneme
    if(strfind(tline,'~h'))
        lineinchar=isspace(linein);
        loc=find(lineinchar==1,2,'first');
        phone=char(linein((loc(1)+2):(size(linein,2)-1)));
    end
    
    %For each state
    if(strfind(tline,'<STATE>'))
        countmix=0;
    end
    
    %For each mixture
    if(strfind(tline,'<MIXTURE>'))
        lineinchar=isspace(linein);
        loc=find(lineinchar==1,3,'first');
        weight=char(linein(loc(2):size(linein,2)));
        countmix=countmix+1;
        
        mix.priors(countmix)=str2double(weight);
    end
    
    if(strfind(tline,'<MEAN>'))
        tline = fgets(fid);
        temp=regexp(tline,'[\r\f\n]','split');
        linein=temp{1};
        
        lineinchar=isspace(linein);
        loc=find(lineinchar==1);
        loc=[loc size(linein,2)];
        mean=zeros(1,size(loc,2)-1);
        for cnt=1:(size(loc,2)-1)
            meanstr=char(linein(loc(cnt):loc(cnt+1)));
            mean(:,cnt)=str2double(meanstr);
        end
        mix.centres(countmix,:)=mean;
    end
    
    if(strfind(tline,'<VARIANCE>'))
        tline = fgets(fid);
        temp=regexp(tline,'[\r\f\n]','split');
        linein=temp{1};
        
        lineinchar=isspace(linein);
        loc=find(lineinchar==1);
        loc=[loc size(linein,2)];
        var=zeros(1,size(loc,2)-1);
        for cntv=1:(size(loc,2)-1)
            varstr=char(linein(loc(cntv):loc(cntv+1)));
            var(:,cntv)=str2double(varstr);
        end
        mix.covars(countmix,:)=var;
    end
    
    
    if(strfind(tline,'<TRANSP>'))
            mix.ncentres=size(mix.priors,2);
            mix.nin=size(mix.centres,2);
            mix.type='gmm'; mix.covar_type='diag';
            save(strcat(GMM_dir,phone,'.mat'),'mix');       
    end;
    
    clear('loc','lineinchar');
    
end;
fclose(fid);
end
