function[complete_data]=missing_samples_estimate(incomplete_data, missing_indices, gmm_parameters, filter_parameters, optimization_parameter, no_of_iteration)

%--Inputs--

%incomplete_data :d*N matrix which contains missing data points
%missing_indices :d*N matrix, which has '0' in the place of missing data points and
%'1' in the place of known data points

%filter_parameter: row vector([filter_order cutoff frequency sampling frequency])

%gmm_parameters: In the form of a structure with 3 fields

 %gmm_parameters.mu= A matrix whose i-th raw is the mean of i-th Gaussian component;
 %gmm_parameters.Sigma= 3 diamentional matrix, Sigma(:,:,i) is the covarience matrix of i-th Gaussian;
 %gmm_parameters.PComponent= Raw vector whose i-th element is the weight of i-th Gaussian;
 
%optimization_parameter: The parameter used in the optimization;

%no_of_iteration: Number of iteration for the EM algorithm;

%--Outputs--

%complete_data: d*N matrix which contains the estimated values in place of missing samples locations

if nargin==3
    filter_parameters=[100 30 500];
    optimization_parameter=10^-7;
    no_of_iteration=3;
else if nargin==4
    optimization_parameter=10^-7;
    no_of_iteration=3;
else if nargin==5
        no_of_iteration=3;
    end
    end
end

filter_order=filter_parameters(1);fcut=filter_parameters(2);fsam=filter_parameters(3);
gmm_means=gmm_parameters.mu; gmm_covariance=gmm_parameters.Sigma; gmm_weights=gmm_parameters.PComponents;
con=optimization_parameter;
complete_data=incomplete_data;
no_of_gmm_components=numel(gmm_weights);



for l=1:numel(missing_indices(:,1))
    for l1=1:numel(missing_indices(1,:))
        if(missing_indices(l,l1)==0)
            missing_trajectories_indices=find(missing_indices(:,l1)==0);
            x=incomplete_data(:,l1); mup=gmm_means;mum=gmm_means(:,l);
            mup(:,missing_trajectories_indices)=[];
            sigpp=gmm_covariance;sigpp(missing_trajectories_indices,:,:)=[];
            sigpp(:,missing_trajectories_indices,:)=[];sigmm=gmm_covariance(l,l,:);
            sigpm=gmm_covariance(l,:,:);sigpm(:,missing_trajectories_indices,:)=[];
            pxp=0;xp=x'; xp(:,missing_trajectories_indices)=[];
            for j=1:no_of_gmm_components
            pxp=pxp+gmm_weights(j)*(1/(2*pi*det(sigpp(:,:,j)))^(.5))*exp(-(.5)*(xp-mup(j,:))*inv(sigpp(:,:,j))*(xp-mup(j,:))');
            end
            for j=1:no_of_gmm_components
            pi_mgiven_p(j)=gmm_weights(j)*(1/(2*pi*det(sigpp(:,:,j)))^(.5))*exp(-(.5)*(xp-mup(j,:))*inv(sigpp(:,:,j))*(xp-mup(j,:))')/pxp;
            u_mgiven_p(j,:)=mum(j,:)+(sigpm(:,:,j)*inv(sigpp(:,:,j))*(xp-mup(j,:))')';
            sig_mgiven_p(:,:,j)=sigmm(:,:,j)-sigpm(:,:,j)*inv(sigpp(:,:,j))*sigpm(:,:,j)';
            end
            pi_p(l1,:)=pi_mgiven_p;sigmgp(l1,:)=sig_mgiven_p;sigmgu(l1,:)=u_mgiven_p;  
        end
    end
      
or=filter_order;
sig2=incomplete_data(l,:).*missing_indices(l,:);
known_ind=find(missing_indices(l,:)==1);
sig2=[sig2(known_ind(1))*ones(1,or+1) sig2 sig2(known_ind(numel(known_ind)))*ones(1,or+1)];
fs1=fcut/fsam;
h = fir1(or,2*fs1,'high',chebwin(or+1,200));
missing_locations_trajectories=find(missing_indices(l,:)==0);
no_of_missing_samples=numel(missing_locations_trajectories);
missing_locations_trajectories=missing_locations_trajectories+ones(1,no_of_missing_samples)*(or+1);
A=zeros(no_of_missing_samples,no_of_missing_samples);
c=xcorr(h);
for repeat=1:no_of_iteration 
 if(repeat>1)
  for i=1:1:numel(missing_indices(1,:))
      if(missing_indices(l,i)==0)
     x=complete_data(:,i)';
     missing_trajectories_indices=find(missing_indices(:,i)==0);
     x(missing_trajectories_indices)=[];x=x';
     mu1=gmm_means;
     mu1(:,missing_trajectories_indices)=[];
     sig1=gmm_covariance;
     sig1(missing_trajectories_indices,:,:)=[];
     sig1(:,missing_trajectories_indices,:)=[];
     lambda1=gmm_weights;
     xp=x;pxp=0;
    for j=1:no_of_gmm_components
     pxp=pxp+lambda1(j)*(1/(2*pi*det(sig1(:,:,j)))^.5)*exp(-(x'-mu1(j,:))*inv(sig1(:,:,j))*(x'-mu1(j,:))');
    end
    for j=1:no_of_gmm_components
      pi_p1(i,j)=lambda1(j)*(1/(2*pi*det(sig1(:,:,j)))^.5)*exp(-(x'-mu1(j,:))*inv(sig1(:,:,j))*(x'-mu1(j,:))')/pxp;
    end
      end
  end 
 else
   pi_p1=pi_p;  
 end    
 for i=1:1:no_of_missing_samples  
    for j=1:1:no_of_missing_samples
        if ((or+1-abs(missing_locations_trajectories(i)-missing_locations_trajectories(j))>0))
        A(i,j)=c(or+1-abs(missing_locations_trajectories(i)-missing_locations_trajectories(j)));
        else
            A(i,j)=0;
        end
        if(i==j)
        kon=0;
        for kj=1:no_of_gmm_components
        kon=kon+(1/sigmgp(missing_locations_trajectories(i)-or-1,kj))*pi_p1(missing_locations_trajectories(i)-or-1,kj);
        end
        A(i,j)=A(i,j)+con*kon;  
        end
    end
end
B=zeros(no_of_missing_samples,1);
for i=1:no_of_missing_samples
    k=0;
    for j=-or:1:or
        k=k+sig2(missing_locations_trajectories(i)+j)*c(or+1-j);
    end
    kon=0;
    for kj=1:no_of_gmm_components
        kon=kon+(sigmgu(missing_locations_trajectories(i)-or-1,kj)/sigmgp(missing_locations_trajectories(i)-or-1,kj))*pi_p1(missing_locations_trajectories(i)-or-1,kj);
    end
    B(i,1)=k-con*kon;   
end
Y=-(inv(A)*B);
for ii=1:1:no_of_missing_samples
complete_data(l,missing_locations_trajectories(ii)-or-1)=Y(ii,1);
end
end
end
end