function[gmm_parameters]=gmm_parameters_learn(training_data,no_of_gmm_components ,max_no_of_iterations)

%       --Inputs--
%Training_date: Should be in the form of d*N matrix where d is the diamension of the data and N is the number of data point
%no_of_gmm_components: The number of Gaussians in the mixtrue
%max_no_of_iterations: maximum number of iterations for EM algorithm

%      --Outputs--
%gmm_means-     A matrix in which i-th raw is the mean of i-th Gaussian
%gmm_varience-  d*d*p matrix where gmm_varience(:,:,i)is the covarience matrix of i-th gaussian
%gmm_weights-   A raw vector in which i-th element is the weight of i-th Gaussian
[m n]=size(training_data)
if m>n
    error('Dimensions is greater than no of data points');
end

options=statset('MaxIter',max_no_of_iterations);
gmm_parameters=gmdistribution.fit(training_data',no_of_gmm_components,'Options',options);
end